/*
*  DISCLAIMER:
*
*      THIS SOFTWARE, SOURCE CODE AND ASSOCIATED MATERIALS INCLUDING BUT NOT LIMITED TO TUTORIALS,
*      GUIDES AND COMMENTARY PROVIDED WITH THIS EXERCISE ARE ONLY DESIGNED FOR REFERENCE PURPOSES
*      TO GIVE AN EXAMPLE TO LICENSEE FOR THEIR OWN NECESSARY DEVELOPMENT OF THEIR OWN SOFTWARE AND/OR
*      APPLICATION. IT IS NOT DESIGNED FOR ANY SPECIAL PURPOSE, SERIAL PRODUCTION OR USE IN MEDICAL,
*      MILITARY, AIR CRAFT, AVIATION, SPACE OF LIFE SUPPORT EQUIPMENT.
*
*      TO THE EXTENT PERMITTED BY LAW, THE EXERCISE SOFTWARE AND/OR SOURCE CODE AND/OR AND ASSOCIATED
*      MATERIALS IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND AND ONLY FOR REFERENCE PURPOSES.
*
*      SYNAPTIC LABORATORIES LTD. MAKES NO WARRANTIES, EITHER EXPRESS OR IMPLIED, WITH RESPECT TO THE
*      LICENSED SOFTWARE AND/OR SOURCE CODE AND/OR ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND
*      DOCUMENTATION PROVIDED HEREUNDER.
*
*      SYNAPTIC LABORATORIES LTD. SPECIFICALLY DISCLAIMS THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*      FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT OF ANY INTELLECTUAL
*      PROPERTY RIGHT OF ANY THIRD PARTY WITH REGARD TO THE SOFTWARE, DOCUMENTATION (SCHEMATICS ETC.),
*      SOURCE CODE AND ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND DOCUMENTATION.
*
*      ANY USE, COMPILATION AND TESTING OF THE SOFTWARE AND/OR SOURCE CODE IS AT LICENSEE`S OWN RISK
*      AND LICENSEE IS OBLIGED TO CONDUCT EXTENSIVE TESTS TO AVOID ANY ERRORS AND FAILURE IN THE
*      COMPILED SOURCE CODE, DOCUMENTATION (SCHEMATICS ETC.) AND THE HEREFROM GENERATED SOFTWARE
*      OF LICENSEE.
*
*      EXCEPT FOR WILFULL INTENT SYNAPTIC LABORATORIES LTD. SHALL IN NO EVENT BE ENTITLED TO OR LIABLE
*      FOR ANY INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND OR NATURE, INCLUDING,
*      WITHOUT LIMITATION, BUSINESS INTERRUPTION COSTS, LOSS OF PROFIT OR REVENUE, LOSS OF DATA,
*      PROMOTIONAL OR MANUFACTURING EXPENSES, OVERHEAD, COSTS OR EXPENSES ASSOCIATED WITH WARRANTY
*      OR INTELLECTUAL PROPERTY INFRINGEMENT CLAIMS, INJURY TO REPUTATION OR LOSS OF CUSTOMERS.
*
*/


module test_board(
input wire	CLK12M,
input wire	RESET,

//uart
input wire	BDBUS0,
output wire	BDBUS1,

//user button
input wire	USER_BTN,

//SDRAM
output wire	CAS,
output wire	RAS,
output wire	WE ,
output wire	CLK,
output wire	[11:0] A,
output wire	[1:0] BA,
inout  tri	[15:0] DQ,
output wire	[1:0] DQM,


//Power control
output wire         pwr_ctr_vid0,
output wire         pwr_ctr_vid1,
output wire         pwr_ctr_vid2,
output wire         pwr_ctr_enable,


//PSRAM ignals
output wire         crbus0_rstn   , // Flash-PSRAM signals : reset to HyperFlash
output wire         crbus0_clk0p  , // Flash-PSRAM signals : Clk diff (p)
output wire         crbus0_clk0n  , // Flash-PSRAM signals : Clk diff (n)
output wire         crbus0_cs1n   , // Flash-Flash signals : Flash Chip Select
output wire         crbus0_cs2n   , // Flash-PSRAM signals : PSRAM Chip Select
inout  tri          crbus0_rwds   , // Flash-PSRAM signals : read strobe - write mask
inout  tri  [7:0]   crbus0_dq     , // Flash-PSRAM signals : Data


//LED
output wire	LED1,
output wire	LED2
);

//---------------------------------------------------------
//inernal signals
//---------------------------------------------------------
wire	pll_clk_100mhz;

//---------------------------------------------------------
//Power Control
//# EP53A7HQI power and VID control
//# VID=000 3.3V
//# VID=100 2.5V
//# VID=111 1.8V
//---------------------------------------------------------
 assign pwr_ctr_enable = 1'b1;
 assign pwr_ctr_vid0   = 1'b1;
 assign pwr_ctr_vid1   = 1'b1;
 assign pwr_ctr_vid2   = 1'b1;


  wire   nrst;
  assign nrst = 1'b1;
//---------------------------------------------------------
//QSYS system
//---------------------------------------------------------
NIOS_test_board	b2v_inst(
	.clk_clk(CLK12M),
	.reset_reset_n(nrst),
	.pll100mhz_clk(pll_clk_100mhz),

//	.uart_rxd(BDBUS0),
//	.uart_txd(BDBUS1),

  .sll_xspi_mc_top_MB0_CLK0  (crbus0_clk0p),
  .sll_xspi_mc_top_MB0_CLK0n (crbus0_clk0n),
  .sll_xspi_mc_top_MB0_CLK1  (         ),
  .sll_xspi_mc_top_MB0_CLK1n (         ),
  .sll_xspi_mc_top_MB0_CS0n  (crbus0_cs1n ),
  .sll_xspi_mc_top_MB0_CS1n  (crbus0_cs2n ),
  .sll_xspi_mc_top_MB0_RWDS  (crbus0_rwds ),
  .sll_xspi_mc_top_MB0_DQ    (crbus0_dq   ),
  .sll_xspi_mc_top_MB0_RSTn  (crbus0_rstn ),
	.sll_xspi_mc_top_MB0_WPn   (         ),          
	.sll_xspi_mc_top_MB0_RSTOn (1'b1     ),      
	.sll_xspi_mc_top_MB0_INTn  (1'b1     ), 
	
	.sdram_cas_n(CAS),	
	.sdram_ras_n(RAS),
	.sdram_we_n(WE),
	.sdram_addr(A),
	.sdram_ba(BA),
	.sdram_dq(DQ),
	.sdram_dqm(DQM),
	
	.led_export(LED1)
	
);


//
//sdram clock out
//
ddrclk	b2v_inst3(
	.outclock(pll_clk_100mhz),
	.din({1'b0, 1'b1}),
	.pad_out(CLK));



//-----------------------------------------
//Heart beat by 12MHz clock
//-----------------------------------------
//Heart-beat counter
reg   [25:0]  heart_beat_cnt;

always @(posedge CLK12M or negedge RESET)
  if (!RESET)
      heart_beat_cnt <= 26'h0;
  else
      heart_beat_cnt <= heart_beat_cnt + 1'b1;

//LED output
 assign LED2 = heart_beat_cnt[25];


endmodule
